% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/label.R
\name{LabeljsTable}
\alias{LabeljsTable}
\title{LabeljsTable: Apply label information to jstable object using label data}
\usage{
LabeljsTable(obj.table, ref)
}
\arguments{
\item{obj.table}{table of geeglm.display, lmer.display, coxme.display}

\item{ref}{Label data made by mk.lev function}
}
\value{
table of geeglm.display, lmer.display, coxme.display with label information
}
\description{
Apply label information to table of geeglm.display, lmer.display, coxme.display using label data
}
\details{
DETAILS
}
\examples{
 library(coxme)
 fit <- coxme(Surv(time, status) ~ sex + ph.ecog + ph.karno + (1|inst) +(1|sex), lung)
 fit.table <- coxme.display(fit)
 lung.label <- mk.lev(lung)
 LabeljsTable(fit.table$table, ref = lung.label)
}
