% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/array_utils.R
\name{json_array_agg}
\alias{json_array_agg}
\title{Aggregate into a JSON array}
\usage{
json_array_agg(x)
}
\arguments{
\item{x}{Vector to collapse into JSON array.}
}
\value{
A \code{json2} vector of length one with the elements of \code{x} collapsed
to a JSON array.
}
\description{
Aggregate into a JSON array
}
\examples{
json_array_agg(1:3)
json_array_agg(json2(c('{"a": 1}', '{"b": 2}')))

# can be quite useful in combination with `dplyr::group_by()`
if (require("dplyr", quietly = TRUE, warn.conflicts = FALSE)) {
  tibble::tibble(
    group = c(1, 1, 2, 2),
    json = c(1:4)
  ) \%>\%
    dplyr::group_by(group) \%>\%
    dplyr::summarise(json = json_array_agg(json))
}
}
