% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{simdat}
\alias{simdat}
\title{Simulated joint longitudinal and survival dataset containing 5 studies}
\format{A list of three objects: \describe{ \item{\code{longitudinal}}{A list
  of long format longitudinal datasets one for each of the 5 studies included
  in the dataset.  Each of these datasets contains the following variables:
  \describe{ \item{\code{id}}{long version of the id variable for the data.
  Identical ids between the longitudinal and the survival datasets identify
  the same individual} \item{\code{Y}}{a continuous longitudinal outcome}
  \item{\code{time}}{the longitudinal time variable} \item{\code{study}}{a
  long version of the study membership indicator} \item{\code{intercept}}{a
  long version of the intercept, always takes a value of 1}
  \item{\code{treat}}{a long version of the binary treatment group indicator}
  \item{\code{ltime}}{a duplicate of the longitudinal time variable,
  duplicated as part of the longitudinal data simulation process} }}

  \item{\code{survival}}{A list of survival datasets, one for each of the 5
  studies included in the dataset.  Each of these datasets contains the
  following variables: \describe{ \item{\code{id}}{the id variable for the
  data. Identical ids between the longitudinal and the survival datasets
  identify the same individual} \item{\code{survtime}}{the survival time for
  each individual at which they experienced the event or were censored.  This
  is on the same scale as the longitudinal time measurements.}
  \item{\code{cens}}{censoring indicator for the survival data where 1
  indicates an event and 0 indicates censoring} \item{\code{study}}{study
  membership indicator} \item{\code{treat}}{binary treatment group indicator}
  }}

  \item{\code{percentevent}}{A list of the percentage of events experienced
  in each datasets.  The first element contains the percentage of events
  observed for the first simulated study and so on.} }}
\usage{
simdat
}
\description{
A simulated dataset containing a single continuous longitudinal outcome and a
single survival outcome, with data available from 5 studies.
}
\details{
This is a simulated dataset generated using the
  \code{\link{simjointmeta}} function using the following function call:

  \code{ simdat<-simjointmeta(k = 5, n = rep(500, 5), sepassoc = FALSE, ntms
  = 5, longmeasuretimes = c(0, 1, 2, 3, 4), beta1 = c(1, 2, 3), beta2 = 3,
  rand_ind = 'intslope', rand_stud = 'inttreat', gamma_ind = 1, gamma_stud =
  1, sigb_ind = matrix(c(1,0.5,0.5,1.5),nrow=2), sigb_stud =
  matrix(c(1,0.5,0.5,1.5),nrow=2), vare = 0.01, theta0 = -3, theta1 = 1,
  censoring = TRUE, censlam = exp(-3), truncation = TRUE, trunctime = 6) }

  Note that this will not give you identical data to that held in
  \code{simdat} due to the differences in starting seed.
}
\seealso{
\code{\link{simjointmeta}}
}
\keyword{datasets}
