% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/points.jointdata.R
\name{points.jointdata}
\alias{points.jointdata}
\title{Add points to an existing \code{jointdata} plot}
\usage{
\method{points}{jointdata}(x, Y.col, ...)
}
\arguments{
\item{x}{object of class \code{jointdata}.}

\item{Y.col}{column number, or column name, of longitudinal variable to be 
plotted. Defaults to \code{Y.col = NA}, plotting all longitudinal
variables.}

\item{...}{other graphical arguments; see \code{\link[graphics]{plot}}.}
}
\value{
A graphical device with a plot for longitudinal data. Other functions
  are useful to be used with this as \code{\link[graphics]{plot}} and 
  \code{\link[graphics]{lines}}.
}
\description{
Add points to an existing plot of an object of class
  \code{jointdata}, for a longitudinal variable. It is possible plot all the
  subjects in the data set, or just a selected \code{subset}. See
  \code{\link{subset.jointdata}}.
}
\examples{
data(heart.valve)
heart.surv <- UniqueVariables(heart.valve,
                              var.col = c("fuyrs", "status"),
                              id.col = "num")
heart.long <- heart.valve[, c(1, 4, 5, 7, 8, 9, 10, 11)]
heart.jd <- jointdata(longitudinal = heart.long,
                      survival = heart.surv,
                      id.col = "num",
                      time.col = "time")
                      
# Randomly select a pair of subjects to plot profiles of
take <- sample(1 : max(heart.jd$survival$num), 2)
heart.jd.1 <- subset(heart.jd, take[1])
heart.jd.2 <- subset(heart.jd, take[2])

plot(heart.jd.1, Y.col = "grad", type = "p")
points(heart.jd.2, Y.col = "grad", col = "blue", pch = 20)
}
\author{
Ines Sousa (\email{isousa@math.uminho.pt})
}
\keyword{aplot}
