% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jlctree.R
\name{jlctree}
\alias{jlctree}
\title{Fits Joint Latent Class Tree (JLCT) model.}
\usage{
jlctree(survival, classmb, fixed, random, subject, data, parms = list(),
  control = list())
}
\arguments{
\item{survival}{a two-sided formula object; required. The left side of the formula corresponds
to a \code{Surv()} object of type ``counting'' for left-truncated right-censored (LTRC) data,
or of type ``right'' for right-censored data.
The right side of the formula specifies the names of covariates to include in the survival model,
excluding the longitudinal outcome.}

\item{classmb}{one-sided formula describing the covariates in the class-membership tree construction; required.
Covariates used for tree construction are separated by \code{+} on the right of \code{~}.}

\item{fixed}{two-sided linear formula object for the fixed-effects in the linear mixed-effects model for 
longitudinal outcomes; required.
The longitudinal outcome is on the left of \code{~} and the covariates are separated by \code{+} 
on the right of \code{~}.}

\item{random}{one-sided formula for the node-specific random effects in the linear mixed-effects model for 
longitudinal outcomes; optional. 
If missing, there are no node-specific random effects in the fitted linear mixed-effects model.
Covariates with a random effect are separated by \code{+} on the right of \code{~}.}

\item{subject}{name of the covariate representing the subject identifier; optional. 
If missing, there are no subject-specific random intercepts in the fitted linear mixed-effects model for
longitudinal outcomes.}

\item{data}{the dataset; required.}

\item{parms}{parameter list of Joint Latent Class Tree model parameters. 
See also \code{jlctree.control}.}

\item{control}{\code{rpart} control parameters. See also \code{rpart.control}.}
}
\value{
A list with components:
 \item{tree}{an \code{rpart} object, containing the constructed Joint Latent Class tree.}
 \item{control}{the \code{rpart.control} parameters.}
 \item{parms}{the \code{jlctree.control} parameters.}
 \item{lmmmodel}{an \code{lme4} object, containing the linear mixed-effects effects model
     with fixed effects, node-specific random effects (if valid), 
     and subject-specific random intercepts (if valid). 
     Returned when \code{fity} is TRUE.}
 \item{coxphmodel_diffh_diffs}{a \code{coxph} object, containing a Cox PH model
     with different hazards and different slopes across terminal nodes.
     Returned when \code{fits} is TRUE.}
  \item{coxphmodel_diffh}{a \code{coxph} object, containing a Cox PH model 
     with different hazards but same slopes across terminal nodes.
     Returned when \code{fits} is TRUE.}
  \item{coxphmodel_diffs}{a \code{coxph} object, containing a Cox PH model 
     with same hazards but different slopes across terminal nodes.
     Returned when \code{fits} is TRUE.}
}
\description{
Fits Joint Latent Class Tree model. 
 This is the main function that is normally called by the user.
 See \code{\link{jlctree-package}} for more details.
}
\examples{
 # Time-to-event in LTRC format:
 data(data_timevar)
 tree <- jlctree(survival=Surv(time_L, time_Y, delta)~X3+X4+X5,
                 classmb=~X1+X2, fixed=y~X1+X2+X3+X4+X5, random=~1,
                 subject='ID',data=subset(data_timevar, ID<=30),
                 parms=list(maxng=4, fity=FALSE, fits=FALSE))

 # Time-to-event in right-censored format:
 data(data_timeinv)
 tree <- jlctree(survival=Surv(time_Y, delta)~X3+X4+X5,
                 classmb=~X1+X2, fixed=y~X1+X2+X3+X4+X5, random=~1,
                 subject='ID', data=subset(data_timeinv, ID<=30),
                 parms=list(maxng=4, fity=FALSE, fits=FALSE))

}
\seealso{
\code{\link{jlctree-package}, \link{jlctree.control}, \link{rpart.control}}
}
