#' Just a Rather Bayesian Evidence Synthesis
#'
#' This package was developed with the aim of simplifying the use of meta-analysis
#' models that combine obsevational and experimental data (e.g. randomized control trials).
#' The package implements a series of innovative statistical models from the class:
#' Hierarchical Meta-Regression models. This class of models aims to explicitelly model
#' the different types of biases that we have to face when we combine evidence of different
#' study types.
#'
#'
#' \tabular{ll}{
#' Package:  \tab jarbes     \cr
#' Type:     \tab Package    \cr
#' Version:  \tab 1.7.2      \cr
#' Date:     \tab 2019-03-11 \cr
#' License:  \tab GPL (>= 2) \cr
#' LazyLoad: \tab yes        \cr }
#'
#' @name jarbes
#' @aliases jarbes
#' @docType package
#'
#' @author PD Dr. Pablo Emilio Verde \email{pabloemilio.verde@hhu.de}
#'
#' @references Verde, P.E, Ohmann, C., Icks, A. and Morbach, S. (2016) Bayesian
#' evidence synthesis and combining randomized and nonrandomized results: a case
#' study in diabetes. Statistics in Medicine. Volume 35, Issue 10, 10 May 2016,
#' Pages: 1654 to 1675.
#'
#' @references Verde, P. E. (2017) Two Examples of Bayesian Evidence Synthesis
#' with the Hierarchical Meta-Regression Approach. Chap.9, pag 189-206.
#' Bayesian Inference, ed. Tejedor, Javier Prieto. InTech. doi 10.5772/intechopen.70231.
#'
#' @references Verde, P. E. (2019) The Hierarchical Meta-Regression Approach and
#' Learning from Clinical Evidence. Biometrical Journal, 2018;1–23.
#'
#' @keywords Hierarchical Modeling, Bayesian Meta-Analysis, Generalized Evidence Synthesis,
#' Conflict of Evidence, Outliers Detection, Multiparameters Meta-Analysis.
#'
