% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba-heatmap-order.R
\name{heatmap_row_order}
\alias{heatmap_row_order}
\title{Return Heatmap row order from ComplexHeatmap heatmap object}
\usage{
heatmap_row_order(hm, which_heatmap = NULL)
}
\arguments{
\item{hm}{\code{Heatmap} or \code{HeatmapList} object as defined by the
Bioconductor package via \code{ComplexHeatmap::Heatmap()}.}

\item{which_heatmap}{\code{integer}, default NULL, used when the input
is a \code{HeatmapList} with multiple heatmaps.}
}
\value{
output depends upon the heatmap:
\itemize{
\item When heatmap rows are grouped using \code{row_split}, and
when the data matrix contains rownames,
returns a \code{character} vector of rownames in the order they
appear in the heatmap. When there are no rownames, \code{integer}
row index values are returned. If the heatmap has row labels,
they are returned as vector names.
\item When rows are grouped using \code{row_split}, it returns a
\code{list} of vectors as described above. The \code{list}
is named using the \code{row_title} labels only when there is
an equal number of row labels.
}
}
\description{
Return Heatmap row order from ComplexHeatmap heatmap object
}
\details{
This function is a helpful utility to return the fully
qualified list of rownames in a \code{ComplexHeatmap::Heatmap}
object.

The core intention is for the output to be usable with the
original data matrix used in the heatmap. Therefore, the
vector values are \code{rownames()} when present, or \code{integer}
row index values when there are no \code{rownames()}. If heatmap
\code{row_labels} are defined, they are returned as \code{names()}.

Note that \code{names()} are assigned inside \code{try()} to allow the
case where \code{row_labels}, or \code{row_title} labels cannot be
coerced to \code{character} values, for example using \code{gridtext}
for markdown formatting.

Final note: It is best practice to draw the heatmap first
with \code{ComplexHeatmap::draw()} then store the output in a new
object. This step creates the definitive clustering and
therefore the row order is absolutely final, not subject
to potential randomness during clustering.
}
\examples{
# See heatmap_column_order() for examples

}
\seealso{
Other jam heatmap functions: 
\code{\link{cell_fun_label}()},
\code{\link{heatmap_column_order}()}
}
\concept{jam heatmap functions}
