% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jagshelper1.R
\name{traceworstRhat}
\alias{traceworstRhat}
\title{Trace plots corresponding to the worst values of Rhat}
\usage{
traceworstRhat(x, p = NULL, n.eff = FALSE, margin = NULL, parmfrow = NULL, ...)
}
\arguments{
\item{x}{Output object returned from \code{jagsUI}}

\item{p}{Optional vector of parameters to subset}

\item{n.eff}{Whether to plot parameters with the smallest associated values of \code{n.eff} instead.  Defaults to \code{FALSE}.}

\item{margin}{In the case of a 2+ dimensional array associated with a given parameter, this will have the effect
of plotting the worst \code{Rhat} corresponding to each margin specified.  For example, specifying \code{margin=2} (column)
will plot the parameter with the worst \code{Rhat} value from each column.  In contrast, specifying \code{margin=NULL} (the default)
will cause the function to plot the single array element with the largest Rhat value.}

\item{parmfrow}{Optional call to \code{par(mfrow)} for the number of rows & columns of plot window.  Returns the graphics device to previous state afterward.}

\item{...}{additional plotting arguments or arguments to \code{tracedens_jags()}}
}
\value{
\code{NULL}
}
\description{
Trace plots with kernel densities will be created for parameters with the largest (worst) associated values of \code{Rhat}.
This function is primarily intended for parameters with a vector (or array) of values.

\code{Rhat} (Gelman-Rubin Convergence Diagnostic, or Potential Scale Reduction Factor)
is calculated within 'JAGS', and is
commonly used as a measure of convergence for a given parameter node.  Values close
to 1 are seen as evidence of adequate convergence.  \code{n.eff} is also calculated within 'JAGS', and may be interpreted as a crude measure of
effective sample size for a given parameter node.
}
\examples{
## plotting everything
traceworstRhat(SS_out, parmfrow=c(3,2))
SS_out$Rhat  # the associated values

traceworstRhat(SS_out, parmfrow=c(3,2), n.eff=TRUE)
SS_out$n.eff  # the associated values

## in the case of a 2-D array, setting margin=2 gives the max Rhat
## associated with each column, rather than the global max
traceworstRhat(x=SS_out, p="cycle_s", margin=2, parmfrow=c(2,2))
SS_out$Rhat
traceworstRhat(x=SS_out, p="cycle_s", margin=2, parmfrow=c(2,2), n.eff=TRUE)
SS_out$n.eff
}
\references{
Gelman, A., & Rubin, D. B. (1992). Inference from Iterative Simulation
Using Multiple Sequences. \emph{Statistical Science, 7}(4), 457–472. http://www.jstor.org/stable/2246093
}
\seealso{
\link{plotRhats}, \link{check_Rhat}
}
\author{
Matt Tyers
}
