% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jagshelper1.R
\name{comparedens}
\alias{comparedens}
\title{Compare Density}
\usage{
comparedens(
  x1,
  x2,
  p = NULL,
  minCI = 0.99,
  legendnames = NULL,
  legendpos = "topleft",
  ...
)
}
\arguments{
\item{x1}{Output object returned from \code{jagsUI}; or alternately a \code{data.frame}}

\item{x2}{Second output object returned from \code{jagsUI}; or alternately a \code{data.frame}}

\item{p}{Optional vector of parameters to subset.  All parameters with names matching the beginning of the
string supplied will be returned.  If the default (\code{NULL}) is accepted, all parameters will be plotted.}

\item{minCI}{Minimum CI width for plotting.  This is intended as a method for excluding far-outlying MCMC
samples when determining the appropriate y-axis limits for plotting.  Defaults to 99\%.}

\item{legendnames}{Names for optional legend.  If the default \code{NULL} is accepted, no legend will be drawn.}

\item{legendpos}{Position for optional legend.  Defaults to \code{"topleft"}.}

\item{...}{additional plotting arguments}
}
\value{
\code{NULL}
}
\description{
Side-by-side kernel density plots for all parameters (or a specified subset) from two \code{jagsUI}
output objects or \code{data.frame}s.  The intent of this function is easy comparison of inferences from two comparable models.

Kernel densities are plotted vertically, either left- or right-facing.  Parameters with the same name are
plotted facing one another.
}
\examples{
## This is the same output object twice, but shows functionality.
comparedens(x1=asdf_jags_out, x2=asdf_jags_out, p=c("a","b","sig"),
            legendnames=c("Model 1", "Model 2"))
}
\seealso{
\link{comparecat}
}
\author{
Matt Tyers
}
