% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variable_contrib.R
\name{variable_contrib}
\alias{variable_contrib}
\title{Evaluate variable contributions for targeted observations.}
\usage{
variable_contrib(
  model,
  var_occ,
  var_occ_analysis,
  shap_nsim = 100,
  visualize = FALSE,
  seed = 10
)
}
\arguments{
\item{model}{(\code{isolation_forest}) The isolation forest SDM.
It could be the item \code{model} of \code{POIsotree} made by function \code{\link{isotree_po}}.}

\item{var_occ}{(\code{data.frame}, \code{tibble}) The \code{data.frame} style table that
include values of environmental variables at occurrence locations.}

\item{var_occ_analysis}{(\code{data.frame}, \code{tibble}) The \code{data.frame} style table that
include values of environmental variables at occurrence locations for analysis. It
could be either \code{var_occ} or its subset, or any new dataset.}

\item{shap_nsim}{(\code{integer}) The number of Monte Carlo repetitions in SHAP
method to use for estimating each Shapley value. See details in documentation of
function \code{\link{explain}} in package \code{fastshap}.}

\item{visualize}{(\code{logical}) if \code{TRUE}, plot the response curves.
The default is \code{FALSE}.}

\item{seed}{(\code{integer}) The seed for any random progress. The default is \code{10L}.}
}
\value{
(\code{VariableContribution}) A list of
\itemize{
\item{shapley_values (\code{data.frame}) A table of Shapley values of each variables for
all observations}
\item{feature_values (\code{tibble}) A table of values of each variables for all
observations}}
}
\description{
Evaluate variable contribution for targeted observations according
to SHapley Additive exPlanations (SHAP).
}
\examples{

# Using a pseudo presence-only occurrence dataset of
# virtual species provided in this package
library(dplyr)
library(sf)
library(stars)
library(itsdm)

data("occ_virtual_species")
occ_virtual_species <- occ_virtual_species \%>\%
  mutate(id = row_number())

set.seed(11)
occ <- occ_virtual_species \%>\% sample_frac(0.7)
occ_test <- occ_virtual_species \%>\% filter(! id \%in\% occ$id)
occ <- occ \%>\% select(-id)
occ_test <- occ_test \%>\% select(-id)

env_vars <- system.file(
  'extdata/bioclim_tanzania_10min.tif',
  package = 'itsdm') \%>\% read_stars() \%>\%
  slice('band', c(1, 5, 12, 16))

mod <- isotree_po(
  occ = occ, occ_test = occ_test,
  variables = env_vars, ntrees = 50,
  sample_rate = 0.8, ndim = 3L,
  seed = 123L, response = FALSE,
  spatial_response = FALSE,
  check_variable = FALSE)

var_contribution <- variable_contrib(
  model = mod$model,
  var_occ = mod$var_train \%>\% st_drop_geometry(),
  var_occ_analysis = mod$var_train \%>\%
    st_drop_geometry() \%>\% slice(1:10))
\dontrun{
plot(var_contribution,
  num_features = 3,
  plot_each_obs = TRUE)

# Plot together
plot(var_contribution)
}

}
\references{
\itemize{
\item{\href{https://github.com/bgreenwell/fastshap}{https://github.com/
bgreenwell/fastshap}}
\item{\href{https://github.com/slundberg/shap}{https://github.com/slundberg/shap}}
}
}
\seealso{
\code{\link{plot.VariableContribution}}
\code{\link{explain}} in \code{fastshap}
}
