% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{timeBins}
\alias{timeBins}
\title{Label timestamps as timebins of a given binsize.}
\usage{
timeBins(x, binsize, pos = 0.5)
}
\arguments{
\item{x}{Numerical vector with timestamp information.}

\item{binsize}{Size of the timebin, measured in the same units (often ms) 
as \code{x}.}

\item{pos}{Numerical value that determines the label of the binsize 
as proportion of the binsize. A value of 0 will provide the minimum 
timestamp within the bin as label, a value of 1 will provide the maximum 
value within the bin as label. Defaults to 0.5, the center of the bin.}
}
\value{
Anumerical vector of the same size as \code{x} with timebin 
information.
}
\description{
Function for calculating timebins.
}
\examples{
data(simdat)
# grouping Time values in bins:
simdat$Timebin <- timeBins(simdat$Time, 200)
head(simdat)

# different labels:
simdat$Timebin2 <- timeBins(simdat$Time, 200, pos=0)
head(simdat)
}
\author{
Jacolien van Rij
}
\seealso{
Other Utility functions: \code{\link{convertNonAlphanumeric}},
  \code{\link{diff_terms}}, \code{\link{find_difference}},
  \code{\link{missing_est}}, \code{\link{print_summary}},
  \code{\link{summary_data}}
}

