% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/data_utility_functions.R
\name{getCountData}
\alias{getCountData}
\title{Reducing fixations to count data.}
\usage{
getCountData(x, split_by, data = NULL, values = NULL, incl_na = FALSE)
}
\arguments{
\item{x}{Name of a column in \code{data} or vector with values
to be counted.}

\item{split_by}{Vector with column names in \code{data} or named list with
grouping predictors.}

\item{data}{Optional: data frame.}

\item{values}{Values of \code{x} that should be counted.
If NULL (default) all values are counted.}

\item{incl_na}{Logical: whether or not to return a count of missing values.}
}
\value{
A data frame with cbinded count information.
}
\description{
Function uses \code{\link[base]{table}} with factors
to count the occurrances of each value in the predictor.
}
\section{Note}{

Values that are not specified in \code{values} will be ignored.
}

\section{Note}{

Will be moved to other package.
}
\examples{
# simulate some gaze data:
dat <- data.frame(
 Subject = rep(1:3, 500),
 Timestamp = rep(1:500, 3),
 AOI = rep( rep( c('other','competitor', 'target'), 3),
 c(184, 172, 144, 51, 264, 185, 127, 2, 371)) )
# add missing data:
dat[sample(nrow(dat), size=15),]$AOI <- NA

# add timebins:
dat$Timebin <- timeBins(dat$Timestamp, 100)

# calculate counts:
c1 <- getCountData('AOI', data=dat, split_by=c('Subject', 'Timebin'))
head(c1)
# calculating proportions:
c1$prop <- c1$AOI[,'target'] / ( c1$AOI[,'competitor']+c1$AOI[,'other'])

# calculating counts for specific values, including missing data.
# Note that 'distractor' is not in the data:
c2 <- getCountData('AOI', data=dat, split_by=c('Subject', 'Timebin'),
values=c('target', 'distractor', 'competitor', 'other'), incl_na=TRUE)
head(c2)
}
\author{
Jacolien van Rij
}
\seealso{
\code{\link[base]{table}}
}

