% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/admmft.R
\name{admmft}
\alias{admmft}
\title{ADMM over Fourier method of variable section.}
\usage{
admmft(X,Y,d,m,lambda=NA,noB = 5,noC = 20,noW = 2,sparse.cov = FALSE,
scale.X = FALSE)
}
\arguments{
\item{X}{Design matrix with dimension n-by-p}

\item{Y}{Response matrix with dimension n-by-q}

\item{d}{Structure dimension, default value is 2}

\item{m}{The number of omega. That is, 2m number of integral transforms}

\item{lambda}{Tuning Parameter. If it is not provided, then the optimal lambda value is chosen by cross validation of Fourier transformation method}

\item{noB}{Iterations for update B, default value is 5}

\item{noC}{Iterations for update C, default value is 20}

\item{noW}{Iterations for update weight, default value is 2}

\item{sparse.cov}{If TRUE, then calculate the soft-threshold matrix.}

\item{scale.X}{If TRUE, then standardize each variables for soft-threshold matrix}
}
\value{
The function output is a p-by-d matrix. 
\item{B}{An estimator for the SDR subspace.} 

\item{covxx}{Estimated covartiance matrix}
}
\description{
ADMM over Fourier method of variable section.
}
\details{
\emph{admmft()} function selects the 
sufficient variables using a Fourier transform sparse inverse regression estimators
}
\examples{
\dontrun{
data(raman)
Y=as.matrix(Raman[,c(1100)])
X=as.matrix(Raman[c(2:501)])
estB = admmft(X,Y,1,30,0.5, sparse.cov=TRUE, scale.X=TRUE)
}

 
}
\references{
Weng, J. (2022), Fourier transform sparse inverse regression estimators for sufficient variable selection,
Computational Statistics & Data Analysis, 168, 107380.
}
