% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wh.R
\name{wh}
\alias{wh}
\title{Bootstrap estimation for the bandwidth of the Gaussian kernel density estimation.}
\usage{
wh(y,x,d,wx=0.1,wy=1,wh_seq=seq(0.1,3,by=.1),B=500,space="mean",
                                        method="FM")
}
\arguments{
\item{y}{The n-dimensional response vector.}

\item{x}{The design matrix of the predictors with dimension n-by-p.}

\item{d}{An integer specifying the dimension of the sufficient dimension reduction subspace.}

\item{wx}{(default 0.1). The tuning parameter for the predictor variables.}

\item{wy}{(default 1). The tuning parameter for the response variable.}

\item{wh_seq}{(default 0.1,0.2,...,3). A sequence of candidate bandwidth for the kernel smoothing method.}

\item{B}{(default 500). Number of bootstrap samples.}

\item{space}{(default ``mean''). The defalult is ``mean'' for the central mean subspace. Other option is ``pdf'' for estimating the central subspace.}

\item{method}{(default ``FM''). The integral transformation method. ``FM''for Fourier trans-formation method (Zhu and Zeng 2006), and
``CM''for convolution transformation method (Zeng and Zhu 2010).}
}
\value{
The outputs are a table of average bootstrap distances between two subspaces for each candidate value of the bandwidth and the estimated value for the bandwith. 
\item{dis_h}{A table of average boostrap distances for each candidate value of the bandwidth.}

\item{h.hat}{The estimated bandwidth parameter for the Gaussian kernel function.}
}
\description{
\emph{wh()} estimates the bandwidth of the Gaussian kernel density estimation function if the distribution of the predictor variables is unknown.
}
\details{
The kernel density estimation of \eqn{f_{\bold{x}}(\bold{x})} at a fixed point \eqn{\bold{x}_0} is defined as
\deqn{\widehat{f}_{\bold{x}_0}(\bold{x})=(nh^p)^{-1}\sum_{\ell=1}^n G\left(\frac{\bold{x}_0-\bold{x}_{\ell}}{h}\right),}
where \eqn{G(\cdot)} is a Gaussian kernel function and `h' is the bandwidth of the 
kernel function. We denote this parameter as `wh` in all functions.
}
\references{
Zeng P. and Zhu Y. (2010).
An Integral Transform Method for Estimating the Central Mean and Central Subspaces. \emph{Journal of Multivariate Analysis}. 101, 1, 271--290.

Zhu Y. and Zeng P. (2006).
Fourier Methods for Estimating the Central Subspace and Central Mean Subspace in Regression. \emph{Journal of the American Statistical Association}. 101, 476, 1638--1651.
}
