% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/issueReport.R
\name{issuesGenPDF}
\alias{issuesGenPDF}
\title{Generate a PDF report from a GitHub issue thread.}
\usage{
issuesGenPDF(style = "tint",
  RmdLocation = system.file("rmarkdown/templates/", "tint.Rmd", package =
  "issueReporter"), outputFile = NULL, outputDir = NULL,
  md = "markdownHere", setTitle = "Issue Notes",
  setAuthor = "Julius Caesar")
}
\arguments{
\item{style}{Character string containing style. Tint is the only available
for now until we add more styles/themes.}

\item{RmdLocation}{Character string designating location of model Rmd.}

\item{outputFile}{String containing file name for R Markdown pdf output,
\code{report.Rmd} if NULL.}

\item{outputDir}{String containing directory address for R markdown output,
working directory if NULL.}

\item{md}{Character string containing markdown code to use in the report.
Should be generated by \code{issuesData2md()}.}

\item{setTitle}{String containing report title.}

\item{setAuthor}{String containing report author.}
}
\description{
For a given GitHub issue, extracts all issue comments and generates a PDF
report of each user's contributions to the thread. View /inst/examples/
to see a quick sample and output besides the usage below.
}
