% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isoforest.R
\name{isotree.export.model}
\alias{isotree.export.model}
\title{Export Isolation Forest model}
\usage{
isotree.export.model(model, file, add_metadata_file = FALSE)
}
\arguments{
\item{model}{An Isolation Forest model as returned by function \link{isolation.forest}.}

\item{file}{File path where to save the model. File connections are not accepted, only
file paths}

\item{add_metadata_file}{Whether to generate a JSON file with metadata, which will have
the same name as the model but will end in '.metadata'. This file is not used by the
de-serialization function, it's only meant to be inspected manually, since such contents
will already be written in the produced model file.}
}
\value{
The same `model` object that was passed as input, as invisible.
}
\description{
Save Isolation Forest model to a serialized file along with its
metadata, in order to be used in the Python or the C++ versions of this package.

This function is not suggested to be used for passing models to and from R -
in such case, one can use `saveRDS` and `readRDS` instead, although the function
still works correctly for serializing objects between R sessions.

Note that, if the model was fitted to a `data.frame`, the column names must be
something exportable as JSON, and must be something that Python's Pandas could
use as column names (e.g. strings/character).

Can optionally generate a JSON file with metadata such as the column names and the
levels of categorical variables, which can be inspected visually in order to detect
potential issues (e.g. character encoding) or to make sure that the columns are of
the right types.

Requires the `jsonlite` package in order to work.
}
\details{
The metadata file, if produced, will contain, among other things, the encoding that was used for
categorical columns - this is under `data_info.cat_levels`, as an array of arrays by column,
with the first entry for each column corresponding to category 0, second to category 1,
and so on (the C++ version takes them as integers). When passing `categ_cols`, there
will be no encoding but it will save the maximum category integer and the column
numbers instead of names.

The serialized file can be used in the C++ version by reading it as a binary file
and de-serializing its contents using the C++ function 'deserialize_combined'
(recommended to use 'inspect_serialized_object' beforehand).

Be aware that this function will write raw bytes from memory as-is without compression,
so the file sizes can end up being much larger than when using `saveRDS`.

The metadata is not used in the C++ version, but is necessary for the R and Python versions.

Note that the model treats boolean/logical variables as categorical. Thus, if the model was fit
to a `data.frame` with boolean columns, when importing this model into C++, they need to be
encoded in the same order - e.g. the model might encode `TRUE` as zero and `FALSE`
as one - you need to look at the metadata for this.

The files produced by this function will be compatible between:\itemize{
\item Different operating systems.
\item Different compilers.
\item Different Python/R versions.
\item Systems with different 'size_t' width (e.g. 32-bit and 64-bit),
as long as the file was produced on a system that was either 32-bit or 64-bit,
and as long as each saved value fits within the range of the machine's 'size_t' type.
\item Systems with different 'int' width,
as long as the file was produced on a system that was 16-bit, 32-bit, or 64-bit,
and as long as each saved value fits within the range of the machine's int type.
\item Systems with different bit endianness (e.g. x86 and PPC64 in non-le mode).
\item Versions of this package from 0.3.0 onwards, \bold{but only forwards compatible}
(e.g. a model saved with versions 0.3.0 to 0.3.5 can be loaded under version
0.3.6, but not the other way around, and attempting to do so will cause crashes
and memory curruptions without an informative error message). \bold{This last point applies
also to models saved through save, saveRDS, qsave, and similar}. Note that loading a
model produced by an earlier version of the library might be slightly slower.
}

But will not be compatible between:\itemize{
\item Systems with different floating point numeric representations
(e.g. standard IEEE754 vs. a base-10 system).
\item Versions of this package earlier than 0.3.0.
}
This pretty much guarantees that a given file can be serialized and de-serialized
in the same machine in which it was built, regardless of how the library was compiled.

Reading a serialized model that was produced in a platform with different
characteristics (e.g. 32-bit vs. 64-bit) will be much slower.

On Windows, if compiling this library with a compiler other than MSVC or MINGW,
(not currently supported by CRAN's build systems at the moment of writing)
there might be issues exporting models larger than 2GB.

In non-windows systems, if the file name contains non-ascii characters, the file name
must be in the system's native encoding. In windows, file names with non-ascii
characters are supported as long as the package is compiled with GCC5 or newer.

Note that, while `readRDS` and `load` will not make any changes to the serialized format
of the objects, reading a serialized model from a file will forcibly re-serialize,
using the system's own setup (e.g. 32-bit vs. 64-bit, endianness, etc.), and as such
can be used to convert formats.
}
\seealso{
\link{isotree.import.model} \link{isotree.restore.handle}
}
