% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/ternary_plot.R
\docType{methods}
\name{ternary_plot}
\alias{ternary_plot}
\alias{ternary_plot-method}
\alias{ternary_plot,numeric,numeric,numeric-method}
\alias{ternary_plot,ANY,missing,missing-method}
\title{Ternary Plot}
\usage{
ternary_plot(x, y, z, ...)

\S4method{ternary_plot}{numeric,numeric,numeric}(
  x,
  y,
  z,
  xlim = NULL,
  ylim = NULL,
  zlim = NULL,
  xlab = NULL,
  ylab = NULL,
  zlab = NULL,
  main = NULL,
  sub = NULL,
  ann = graphics::par("ann"),
  axes = TRUE,
  frame.plot = axes,
  panel.first = NULL,
  panel.last = NULL,
  ...
)

\S4method{ternary_plot}{ANY,missing,missing}(
  x,
  xlim = NULL,
  ylim = NULL,
  zlim = NULL,
  xlab = NULL,
  ylab = NULL,
  zlab = NULL,
  main = NULL,
  sub = NULL,
  ann = graphics::par("ann"),
  axes = TRUE,
  frame.plot = axes,
  panel.first = NULL,
  panel.last = NULL,
  ...
)
}
\arguments{
\item{x, y, z}{A \code{\link{numeric}} vector giving the x, y and z ternary coordinates
of a set of points. If \code{y} and \code{z} are missing, an attempt is made to
interpret \code{x} in a suitable way (see \code{\link[grDevices:xyz.coords]{grDevices::xyz.coords()}}).}

\item{...}{Other \link[graphics:par]{graphical parameters} may also be passed as
arguments to this function.}

\item{xlim}{A length-two \code{\link{numeric}} vector giving the \code{x} limits in the
range \eqn{[0,1]}.}

\item{ylim}{A length-two \code{\link{numeric}} vector giving the \code{y} limits in the
range \eqn{[0,1]}.}

\item{zlim}{A length-two \code{\link{numeric}} vector giving the \code{z} limits in the
range \eqn{[0,1]}.}

\item{xlab, ylab, zlab}{A \code{\link{character}} string giving a label for the x, y and
z axes.}

\item{main}{A \code{\link{character}} string giving a main title for the plot.}

\item{sub}{A \code{\link{character}} string giving a subtitle for the plot.}

\item{ann}{A \code{\link{logical}} scalar: should the default annotation (title and x,
y and z axis labels) appear on the plot?}

\item{axes}{A \code{\link{logical}} scalar: should axes be drawn on the plot?}

\item{frame.plot}{A \code{\link{logical}} scalar: should a box be drawn around the
plot?}

\item{panel.first}{An an \code{expression} to be evaluated after the plot axes are
set up but before any plotting takes place. This can be useful for drawing
background grids.}

\item{panel.last}{An \code{expression} to be evaluated after plotting has taken
place but before the axes, title and box are added.}
}
\value{
\code{ternary_plot()} is called it for its side-effects: it results in a graphic
being displayed. Invisibly returns \code{x}.
}
\description{
Produces a ternary plot.
}
\examples{
## Blank plot
ternary_plot(NULL)

## Compositional data
coda <- data.frame(
  X = c(20, 60, 20, 1/3),
  Y = c(20, 20, 60, 1/3),
  Z = c(60, 20, 20, 1/3)
)

## Ternary plot
ternary_plot(coda, pch = 16, col = "red")

## Add a grid
ternary_plot(coda, panel.first = ternary_grid(5, 10))

## Zoom
ternary_plot(coda, xlim = c(0.5, 1), panel.first = ternary_grid())
ternary_plot(coda, ylim = c(0.5, 1), panel.first = ternary_grid())
ternary_plot(coda, zlim = c(0.5, 1), panel.first = ternary_grid())

## Color according to a supplementary variable
## Data from Aitchison 1986
col <- grDevices::colorRampPalette(c("red", "blue"))(nrow(arctic))
ternary_plot(arctic, panel.first = ternary_grid(), pch = 16, col = col)
}
\seealso{
Other graphical elements: 
\code{\link{ternary_axis}()},
\code{\link{ternary_box}()},
\code{\link{ternary_grid}()},
\code{\link{ternary_pairs}()},
\code{\link{ternary_title}()}
}
\author{
N. Frerebeau
}
\concept{graphical elements}
