% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/ternary_arrows.R
\docType{methods}
\name{ternary_arrows}
\alias{ternary_arrows}
\alias{ternary_arrows-method}
\alias{ternary_arrows,numeric,numeric,numeric-method}
\title{Add Arrows to a Ternary Plot}
\usage{
ternary_arrows(x0, y0, z0, ...)

\S4method{ternary_arrows}{numeric,numeric,numeric}(x0, y0, z0, x1 = x0, y1 = y0, z1 = z0, ...)
}
\arguments{
\item{x0, y0, z0}{A \code{\link{numeric}} vector giving the x, y and z ternary
coordinates of points from which to draw.}

\item{...}{Further arguments to be passed to \code{\link[graphics:arrows]{graphics::arrows()}}.}

\item{x1, y1, z1}{A \code{\link{numeric}} vector giving the x, y and z ternary
coordinates of points to which to draw.}
}
\value{
\code{ternary_arrows()} is called it for its side-effects.
}
\description{
Draw arrows between pairs of points.
}
\examples{
## Add arrows
ternary_plot(NULL, panel.first = ternary_grid())
ternary_arrows(x0 = 40, y0 = 20, z0 = 40,
               x1 = 20, y1 = 40, z1 = 40)
}
\seealso{
\code{\link[graphics:arrows]{graphics::arrows()}}

Other geometries: 
\code{\link{ternary_crosshairs}()},
\code{\link{ternary_lines}()},
\code{\link{ternary_points}()},
\code{\link{ternary_polygon}()},
\code{\link{ternary_segments}()},
\code{\link{ternary_text}()}
}
\author{
N. Frerebeau
}
\concept{geometries}
