% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CO2data.R
\docType{data}
\name{CO2data}
\alias{CO2data}
\title{CO2data}
\format{
A data frame with 2020 rows and 3 variables:
\describe{
  \item{yr}{Year of CO2 and d13CO2 measurement}
  \item{Ca}{Atmospheric CO2 concentration, in ppm}
  \item{d13C.atm}{Atmospheric d13CO2, in per mille, ‰}
}
}
\source{
https://www.sciencedirect.com/science/article/abs/pii/S1125786520300874
}
\usage{
data(CO2data)
}
\description{
Compiled records of atmospheric CO2 concentrations and stable carbon isotopes to reconstruct climate and derive plant ecophysiological indices from tree rings. Data are from Belmecheri, Lavergne, 2020, Dendrochronologia. Updated based on their methodology beyond C.E. 2019.
}
\examples{

data(CO2data)
head(CO2data)

}
\references{
Belmecheri, S. & Lavergne, A. (2020). Compiled records of atmospheric
CO2 concentrations and stable carbon isotopes to reconstruct climate and derive
plant ecophysiological indices from tree rings. Dendrochronologia, 63, 125748.
}
\keyword{datasets}
