% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{pspa_y}
\alias{pspa_y}
\title{PSPA M-Estimation for ML-predicted labels}
\usage{
pspa_y(
  X_lab = NA,
  X_unlab = NA,
  Y_lab,
  Yhat_lab,
  Yhat_unlab,
  alpha = 0.05,
  weights = NA,
  quant = NA,
  intercept = FALSE,
  method
)
}
\arguments{
\item{X_lab}{Array or data.frame containing observed covariates in
labeled data.}

\item{X_unlab}{Array or data.frame containing observed or predicted
covariates in unlabeled data.}

\item{Y_lab}{Array or data.frame of observed outcomes in
labeled data.}

\item{Yhat_lab}{Array or data.frame of predicted outcomes in
labeled data.}

\item{Yhat_unlab}{Array or data.frame of predicted outcomes in
unlabeled data.}

\item{alpha}{Specifies the confidence level as 1 - alpha for
confidence intervals.}

\item{weights}{weights vector PSPA linear regression (d-dimensional, where
d equals the number of covariates).}

\item{quant}{quantile for quantile estimation}

\item{intercept}{Boolean indicating if the input covariates' data contains
the intercept (TRUE if the input data contains)}

\item{method}{indicates the method to be used for M-estimation.
Options include "mean", "quantile", "ols", "logistic", and "poisson".}
}
\value{
A summary table presenting point estimates, standard error,
confidence intervals (1 - alpha), P-values, and weights.
}
\description{
\code{pspa_y} function conducts post-prediction M-Estimation.
}
\examples{

data <- sim_data_y()

X_lab <- data$X_lab

X_unlab <- data$X_unlab

Y_lab <- data$Y_lab

Yhat_lab <- data$Yhat_lab

Yhat_unlab <- data$Yhat_unlab

pspa_y(X_lab = X_lab, X_unlab = X_unlab,

 Y_lab = Y_lab, Yhat_lab = Yhat_lab, Yhat_unlab = Yhat_unlab,

 alpha = 0.05, method = "ols")

}
