% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample.R
\name{sample}
\alias{sample}
\alias{sample_ipv4}
\alias{sample_ipv6}
\alias{sample_network}
\title{Sample random addresses}
\usage{
sample_ipv4(size, ..., replace = FALSE)

sample_ipv6(size, ..., replace = FALSE)

sample_network(x, size, ..., replace = FALSE)
}
\arguments{
\item{size}{Integer specifying the number of addresses to return}

\item{...}{These dots are for future extensions and must be empty.}

\item{replace}{Should sampling be with replacement? (default: \code{FALSE})}

\item{x}{An \code{\link{ip_network}} scalar}
}
\value{
An \code{\link{ip_address}} vector
}
\description{
\code{sample_ipv4()} and \code{sample_ipv6()} sample from the entire address space;
\code{sample_network()} samples from a specific network.
}
\examples{
sample_ipv4(5)

sample_ipv6(5)

sample_network(ip_network("192.168.0.0/16"), 5)

sample_network(ip_network("2001:db8::/48"), 5)
}
\seealso{
Use \code{\link[=seq.ip_network]{seq.ip_network()}} to generate \emph{all} addresses in a network.
}
