% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common_network.R
\name{common_network}
\alias{common_network}
\title{Find the common network of two addresses}
\usage{
common_network(address1, address2)
}
\arguments{
\item{address1}{An \code{\link{ip_address}} vector}

\item{address2}{An \code{\link{ip_address}} vector}
}
\value{
An \code{\link{ip_network}} vector
}
\description{
Returns the smallest network that contains both addresses.

This can construct a network from its first and last addresses. However, if
the address range does not match the network boundaries, then the result
extends beyond the original address range. Use \code{\link[=summarize_address_range]{summarize_address_range()}}
to receive a list of networks that exactly match the address range.
}
\examples{
# address range matches network boundaries
common_network(ip_address("192.168.0.0"), ip_address("192.168.0.15"))

# address range does not match network boundaries
common_network(ip_address("192.167.255.255"), ip_address("192.168.0.16"))
}
\seealso{
\code{\link[=summarize_address_range]{summarize_address_range()}}
}
