% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iotable_get.R
\name{iotable_get}
\alias{iotable_get}
\title{Get an input-output table fom bulk file}
\usage{
iotable_get(
  labelled_io_data = NULL,
  source = "germany_1990",
  geo = "DE",
  year = 1990,
  unit = "MIO_EUR",
  stk_flow = "DOM",
  labelling = "iotables",
  data_directory = NULL,
  force_download = TRUE
)
}
\arguments{
\item{labelled_io_data}{If you have downloaded a bulk data file with 
\code{\link{iotables_download}}, it is faster to work with the data
in the memory. Defaults to \code{NULL} when  the data will be retrieved from
the hard disk or from the Eurostat website invoking the same function.}

\item{source}{A data source, for example \code{naio_10_cp1700}. 
 \itemize{
 \item{\code{naio_10_cp1700}}{ Symmetric input-output table at basic prices (product by product)}
 \item{\code{naio_10_pyp1700}}{ Symmetric input-output table at basic prices (product by product) (previous years prices)}
 \item{\code{naio_10_cp1750}}{ Symmetric input-output table at basic prices (industry by industry)}
 \item{\code{naio_10_pyp1750}}{ Symmetric input-output table at basic prices (industry by industry) (previous years prices) }
 \item{\code{naio_10_cp15}}{ Supply table at basic prices incl. transformation into purchasers' prices }
 \item{\code{naio_10_cp16}}{ Use table at purchasers' prices }
 \item{\code{naio_10_cp1610}}{ Use table at basic prices }
 \item{\code{naio_10_pyp1610}}{ Use table at basic prices (previous years prices) (naio_10_pyp1610) }
 \item{\code{naio_10_cp1620}}{ Table of trade and transport margins at basic prices}
 \item{\code{naio_10_pyp1620}}{ Table of trade and transport margins at previous years' prices}
 \item{\code{naio_10_cp1630}}{ Table of taxes less subsidies on products at basic prices}
 \item{\code{naio_10_pyp1630}}{Table of taxes less subsidies on products at previous years' prices}
} 
For further information consult the 
\href{https://ec.europa.eu/eurostat/web/esa-supply-use-input-tables/overview}{Eurostat Symmetric Input-Output Tables} page.}

\item{geo}{A country code or a country name.
For example, \code{SK} or as \code{Slovakia}.}

\item{year}{A numeric variable containing the year. 
Defaults to \code{2010}, because this year has the most data.}

\item{unit}{A character string containing the currency unit,
defaults to \code{MIO_NAC} (million national currency unit). 
The alternative is \code{MIO_EUR}.}

\item{stk_flow}{Defaults to \code{DOM} as domestic output, 
alternative \code{IMP} for imports 
and \code{TOTAL} for total output. For \code{source = 'naio_10_cp1620'} and 
trade and transport margins and  \code{source = 'naio_10_cp1630'} taxes 
less subsidies only \code{TOTAL} is not used.}

\item{labelling}{Defaults to \code{iotables} which gives standard row 
and column names regardless of the source of the table, or if it is a 
product x product, industry x industry or product x industry table.
The alternative is \code{short} or \code{eurostat} which is the 
original short row or column code of Eurostat or OECD.}

\item{data_directory}{Defaults to \code{NULL}, if a valid directory, 
it will try to save the pre-processed data file here with labelling.}

\item{force_download}{Defaults to \code{TRUE}. If \code{FALSE} it will use the existing 
downloaded file in the \code{data_directory} or the temporary 
directory, if it exists. Will force download only in a new session.}
}
\value{
A wide format data.frame with a well-ordered input-output table.
The bulk data files on the Eurostat website are in a long form and they are 
not correctly ordered for further matrix equations.
}
\description{
This function is used to filter out  a single input-output table from
a database, for example a raw file downloaded from the Eurostat 
website.  It provides some functionality to avoid some pitfalls.
}
\details{
Unless you want to work with bulk data files, 
you should not invoke  \code{\link{iotables_download}} 
directly, rather via this function, if and when it is necessary.
}
\examples{
germany_table <- iotable_get( source = "germany_1990", 
                 geo = 'DE', year = 1990, unit = "MIO_EUR", 
                 labelling  = "iotables" )
}
\seealso{
Other import functions: 
\code{\link{employment_get}()},
\code{\link{iotables_download}()},
\code{\link{iotables_metadata_get}()},
\code{\link{iotables_read_tempdir}()}
}
\concept{import functions}
