% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/leontieff_inverse_create.R
\name{leontieff_inverse_create}
\alias{leontieff_inverse_create}
\title{Create the inverse of a Leontieff-matrix.}
\usage{
leontieff_inverse_create(leontieff_matrix)
}
\arguments{
\item{leontieff_matrix}{A Leontieff matrix created by the \code{\link{leontieff_matrix_create}} function.}
}
\description{
The inversion takes place after the basic properties of the Leontieff matrix.
}
\examples{
de_use <- use_table_get ( source = "germany_1990", geo = "DE",
               year = 1990, unit = "MIO_EUR", 
               households = FALSE, labelling = "iotables")

de_output <- output_get ( source = "germany_1990", geo = "DE",
               year = 1990, unit = "MIO_EUR",
               households = FALSE, labelling = "iotables")

de_coeff <- input_coefficient_matrix_create( de_use, de_output, digits = 4)

L <- iotables::leontieff_matrix_create( technology_coefficients_matrix = de_coeff )
I <- leontieff_inverse_create (L)
}
