% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiplier_create.R
\name{multiplier_create}
\alias{multiplier_create}
\title{Create multipliers}
\usage{
multiplier_create(input_vector = NULL, Im = NULL,
  multiplier_name = "multiplier", digits = NULL)
}
\arguments{
\item{input_vector}{An input matrix or vector created by the \code{\link{input_indicator_create}} function.}

\item{Im}{The Leontieff inverse as a named object created by the  \code{\link{leontieff_inverse_create}}
function.}

\item{multiplier_name}{A variable name to be given to the returned multipliers. 
Defaults to 'multiplier'.}

\item{digits}{Rounding digits, if omitted, no rounding takes place.}
}
\description{
This function is in fact a wrapper around the \code{\link{equation_solve}} function, 
adding a key column with the name to the multiplier the maintain structural
consistency.
}
\examples{
de_use <- use_table_get ( source = "germany_1990", geo = "DE",
year = 1990, unit = "MIO_EUR", 
households = FALSE, labelling = "iotables")

de_output <- output_get ( source = "germany_1990", geo = "DE",
                         year = 1990, unit = "MIO_EUR",
                         households = FALSE, labelling = "iotables")

de_emp <- primary_input_get ( input = "employment_total",
           source = "germany_1990", geo = "DE",
           year = 1990,  
           households = FALSE, labelling = "iotables")

de_emp_indicator <- input_indicator_create (de_emp, de_output)

de_coeff <- input_coefficient_matrix_create( de_use,
 de_output, digits = 4)

L_de <- leontieff_matrix_create( technology_coefficients_matrix =
                                   de_coeff )
I_de <- leontieff_inverse_create(L_de)

employment_multipliers <- multiplier_create ( 
           input_vector    = de_emp_indicator,
           Im              = I_de,
           multiplier_name =  "employment_multiplier", 
           digits = 4 )

}
