% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_sim.R
\encoding{utf-8}
\name{scale_sim}
\alias{scale_sim}
\title{Simulate personality scale(s) and an outcome}
\usage{
scale_sim(n, to_n, tn_n = 0, indicators2 = FALSE, cor_to_tn = 0.3,
  cor_to_outcome = 0.4, to_min = 0.4, to_max = 0.7, tn_min = 0.4,
  tn_max = 0.7, n.cat = 5, sdev = 0.8)
}
\arguments{
\item{n}{Number of participants}

\item{to_n}{Number of indicators in a Trait relating to Outcome}

\item{tn_n}{Number of indicators in a Trait Not relating to outcome.}

\item{indicators2}{if TRUE, a secondary set of indicators is created, e.g. to mimic informant-report. Defaults to FALSE}

\item{cor_to_tn}{Correlation between to and tn. Defaults to 0.3}

\item{cor_to_outcome}{correlation between to and outcome. Defaults to 0.4}

\item{to_min}{minimum factor loading for to_n. Defaults to 0.4}

\item{to_max}{maximum factor loading for to_n. Defaults to 0.7}

\item{tn_min}{minimum factor loading for tn_n. Defaults to 0.4}

\item{tn_max}{maximum factor loading for tn_n. Defaults to 0.7}

\item{n.cat}{number of response options. when you go larger than 5, update the
standard deviation as well. Defaults to 5}

\item{sdev}{standard deviation. Defaults to 0.8}
}
\value{
A list object, first object is indicators' matrix and second object is outcome
 vector. If indicators2=TRUE, then a third object is added, which is the  secondary
  indicators' matrix.
}
\description{
Simulates a personality scale which correlates to an outcome. The function can specify
 the number of indicators (i.e. indicators) truly relating to the outcome. Also, the
  function can create a secondary scale, for instance mimicing informant-report
}
\examples{
## Create a scale-outcome set that violates ION. Only 2 indicators out of 8 relate
## to the outcome, the others just relate to the 2 indicators This setting is similar
## to the N5: Impulsiveness - BMI association in Vainik et al (2015) EJP paper.
set.seed(466)
a<-scale_sim(n=2500, to_n=2, tn_n=6)
# Last 2 indicators have considerably higher correlation with the outcome
cor(a[[1]],a[[2]])

## Create a scale-outcome set that has ION, all 8 indicators relate to the outcome
set.seed(466)
b<-scale_sim(n=2500, to_n=8)
# All indicators correlate largely on the same level with the outcome.
cor(b[[1]],b[[2]])

## Create a scale-outcome set that violates ION - only 1 indicator relates to
##the outcome. Include other-report.
set.seed(466)
c<-scale_sim(n=2500, to_n=1, tn_n=7, indicators2=TRUE)
# Last 2 indicators have considerably higher correlation with the outcome
cor(c[[1]],c[[2]])
cor(c[[3]],c[[2]])
}

