% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sim_min_q_normal.R
\name{sim_min_Q_normal}
\alias{sim_min_Q_normal}
\title{sim_min_Q_normal}
\usage{
sim_min_Q_normal(
  demand,
  mean,
  sd,
  leadtime,
  service_level,
  Quantity,
  shortage_cost = FALSE,
  inventory_cost = FALSE,
  ordering_cost = FALSE
)
}
\arguments{
\item{demand}{A vector of demand in N time periods.}

\item{mean}{average demand in N time periods.}

\item{sd}{standard deviation in N time periods.}

\item{leadtime}{lead time from order to arrival}

\item{service_level}{cycle service level requested}

\item{Quantity}{Fixed order quantity to be ordered at min}

\item{shortage_cost}{shortage cost per unit of sales lost}

\item{inventory_cost}{inventory cost per unit.}

\item{ordering_cost}{ordering cost for every time an order is made.}
}
\value{
a list of two date frames, the simulation and the metrics.
}
\description{
Simulating a Min,Q policy or also calleD S,Q policy,  .
}
\details{
The Function takes a demand vector, mean of demand ,sd,lead time and requested service level to simulate and inventory system, 
orders are lost if inventory level is less than requested demand, also ordering is made at
 day t+1, metrics like item fill rate and cycle service level are calculated. the min is calculated based on a normal distribution.
}
\examples{
sim_min_Q_normal(demand = rpois(50,8),mean = 5,sd=1,
service_level = 0.9,leadtime = 4,
shortage_cost = 5, Quantity = 12,inventory_cost = 1,ordering_cost = 50)
}
\author{
"haytham omar  email: <haytham@rescaleanalytics.com>"
}
