% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_raw.R
\name{plot_raw}
\alias{plot_raw}
\title{Plot raw data}
\usage{
plot_raw(
  data,
  type = "boxplot",
  x,
  y,
  group = NULL,
  xlab = NULL,
  ylab = NULL,
  glab = NULL,
  ylimits = NULL,
  xlimits = NULL,
  xrotation = NULL,
  legend = "top",
  xtext = NULL,
  gtext = NULL,
  color = TRUE,
  linetype = 1,
  opt = NULL
)
}
\arguments{
\item{data}{raw data}

\item{type}{Type of graphic. c("boxplot", "scatterplot")}

\item{x}{Axis x variable}

\item{y}{Axis y variable}

\item{group}{Group variable}

\item{xlab}{Title for the axis x}

\item{ylab}{Title for the axis y}

\item{glab}{Title for the legend}

\item{ylimits}{Limits and break of the y axis c(init, end, brakes)}

\item{xlimits}{For scatterplot. Limits and break of the x axis c(init, end, brakes)}

\item{xrotation}{Rotation in x axis c(angle, h, v)}

\item{legend}{the position of legends ("none", "left", "right", "bottom",
"top", or two-element numeric vector)}

\item{xtext}{Text labels in x axis}

\item{gtext}{Text labels in groups}

\item{color}{Colored figure (TRUE), otherwise black & white (FALSE)}

\item{linetype}{Line type for regression. Default = 0}

\item{opt}{Add new layers to the plot}
}
\value{
plot
}
\description{
Function use the raw data for made a boxplot graphic
}
\examples{

\dontrun{

library(inti)
library(gsheet)

url <- paste0("https://docs.google.com/spreadsheets/d/"
              , "1D1KYc5FMTHow_PpW6ijravmkF_z9zES8Incfroi-Tc4/edit#gid=1336259432")
# browseURL(url)

fb <- gsheet2tbl(url)

fb \%>\%
  plot_raw(type = "sca"
           , x = "elt_test"
           , y = "tam_test"
           , group = "testiculo"
           , color = T
           , ylimits = c(0, 1500, 300)
           , linetype = 0
           )

}

}
