% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_design.R
\name{plot_design}
\alias{plot_design}
\title{Fieldbook plot experimental designs}
\usage{
plot_design(
  data,
  factor,
  dim = NULL,
  fill = "plots",
  xlab = NULL,
  ylab = NULL,
  glab = NULL
)
}
\arguments{
\item{data}{Experimental design data frame with the factors and level. See
examples.}

\item{factor}{Vector with the name of the columns with the factors.}

\item{dim}{Dimension for reshape the design arrangement.}

\item{fill}{Value for fill the experimental units (default = "plots").}

\item{xlab}{Title for x axis.}

\item{ylab}{Title for y axis.}

\item{glab}{Title for group axis.}
}
\value{
plot
}
\description{
Plot fieldbook sketch designs based in experimental design
}
\details{
The function allows to plot the experimental design according the
  field experiment design.
}
\examples{

library(inti)
library(googlesheets4)
library(purrr)

if (gs4_has_token()) {

url <- paste0("https://docs.google.com/spreadsheets/d/"
, "1ilw0NHT7mihaM-3U48KzkuMt927xe8ukX6rNuIw2fT0/edit#gid=0")
# browseURL(url)
gs <- as_sheets_id(url)

(fb <- gs \%>\%
    range_read("tarpuy"))

data <- fb \%>\% inti::fieldbook_design(n_factors = 2
                                      , type = "rcbd"
                                      , rep = 3) \%>\% pluck("design")

plot_design(data
            , factor = "temp"
            , dim = "block"
            )

plot_design(data
            , factor = "temp"
            , dim = "9x5"
            )

}

}
