% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/obtainGBIF.R
\name{obtainGBIF}
\alias{obtainGBIF}
\title{obtainGBIF: Function to obtain occurrence data from GBIF.}
\usage{
obtainGBIF(query, geometry, projection, datasettype, filterDistance, ...)
}
\arguments{
\item{query}{The scientific name of the species for which observations need to be obtained.}

\item{geometry}{An \code{sf} object surrounding the study area where observations need to be obtained.}

\item{projection}{The coordinate reference system used for the observations and geometry.}

\item{datasettype}{The type of dataset that is obtained from \emph{GBIF}. Can be one of: \code{PO}, \code{PA}, \code{Counts}.}

\item{filterDistance}{Remove all points x km away from the boundary polygon.}

\item{...}{Additional arguments to pass to \link[rgbif]{occ_download}.}
}
\value{
An \code{sf} object containing the locations and other relevant information of the species obtained from \emph{GBIF}.
}
\description{
Function used to obtain species observations from \emph{GBIF}.
}
