% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DroppingInterval.R
\name{ttest}
\alias{ttest}
\title{Student's t-test to compare two means of objects of class \code{intRvals}}
\usage{
ttest(x, y = NULL, alternative = c("two.sided", "less", "greater"),
  mu = 0, var.equal = FALSE, conf.level = 0.95)
}
\arguments{
\item{x}{an object of class \code{intRvals}, usually a result of a call to \link[intRvals]{estinterval}}

\item{y}{an (optional) object of class \code{intRvals}, usually a result of a call to \link[intRvals]{estinterval}}

\item{alternative}{a character string specifying the alternative hypothesis, must be one of "\code{two.sided}" (default), "\code{greater}" or "\code{less}". You can specify just the initial letter.}

\item{mu}{a number indicating the true value of the mean (or difference in means if you are performing a two sample test).}

\item{var.equal}{a logical variable indicating whether to treat the two variances as being equal. If TRUE then the pooled variance is used to estimate the variance otherwise the Welch (or Satterthwaite) approximation to the degrees of freedom is used.}

\item{conf.level}{confidence level of the interval}
}
\value{
A list with class "\code{htest}" containing the same components as in \link[stats]{t.test}
}
\description{
Performs one and two sample t-tests on objects of class \code{intRvals}
}
\details{
\code{alternative = "greater"} is the alternative that \code{x} has a larger mean than \code{y}.

If the input data are effectively constant (compared to the larger of the two means) an error is generated.
}
\examples{
data(goosedrop)
dr=estinterval(goosedrop$interval)
# perform a one-sample t-test
ttest(dr,mu=200)  #> FALSE, true mean not equal to 200
# two sample t-test
data.beforeMay=goosedrop[goosedrop$date<as.POSIXct('2013-05-01'),]
data.afterMay=goosedrop[goosedrop$date>as.POSIXct('2013-05-01'),]
dr.beforeMay=estinterval(data.beforeMay$interval)
dr.afterMay=estinterval(data.afterMay$interval)
ttest(dr.beforeMay,dr.afterMay)

}
