% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install_load.R
\name{install_load}
\alias{install_load}
\title{Check, Install and Load CRAN & USGS GRAN Packages}
\source{
Check if R package is installed then load library answered by
maloneypatr is the source for the original function. See
\url{http://stackoverflow.com/questions/15155814/check-if-r-package-is-installed-then-load-library}.
}
\usage{
install_load(package1, ...)
}
\arguments{
\item{package1}{R package.}

\item{...}{Any additional R packages.}
}
\value{
Install and load \code{package1} and other packages listed
in the arguments \code{...} and all of the dependencies.
}
\description{
Checks the local R library(ies) to see if the required package(s)
is/are installed or not. If the package(s) is/are not installed,
then the package(s) will be installed along with the required
dependency(ies). This function pulls source or binary packages
from the Revolution Analytics CRAN mirror and/or the USGS GRAN
Repository. Lastly, the chosen package(s) is/are loaded.
}
\examples{
\dontrun{
library(install.load)
# This will install, if not already installed, and load the package(s)
install_load("chron")
install_load("chron", "data.table", "dataRetrieval", "EGRET", "dplyr")
}


}
\author{
maloneypatr, Irucka Embry
}
\seealso{
\code{\link[needs]{needs}}, \code{\link[easypackages]{install_packages}},
  \code{\link[utils]{installed.packages}}, \code{\link[utils]{install.packages}}
}

