% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PrintPackageHelp.R
\name{PrintPackageHelp}
\alias{PrintPackageHelp}
\title{Print Package Help Documentation}
\usage{
PrintPackageHelp(
  pkg,
  file = "",
  internal = FALSE,
  toc = FALSE,
  title_to_name = FALSE,
  notrun = TRUE,
  sep = "<hr>",
  links = pkg,
  ...
)
}
\arguments{
\item{pkg}{'character' vector.
Package name(s)}

\item{file}{'connection' or 'character' string.
Names the file to append output to.
Prints to the standard output connection by default.}

\item{internal}{'logical' flag.
Whether to print help topics flagged with the keyword \dQuote{internal}.}

\item{toc}{'logical' flag.
Whether to format level-2 headers (help-topic titles) using a Markdown syntax.
This is required when specifying the table-of-contents (toc) format option in R Markdown,
see \code{\link[rmarkdown:render]{rmarkdown::render}} function for details.}

\item{title_to_name}{'logical' flag.
Whether to replace the help-topic \dQuote{title} with its \dQuote{name}.}

\item{notrun}{'logical' flag.
Whether to include \code{## Not run} comments in the Examples section of help documentation.}

\item{sep}{'character' string.
HTML to separate help topics, a horizontal line by default.}

\item{links}{'character' vector.
Names of packages searched (level 0) when creating internal hyperlinks to functions and datasets.}

\item{...}{Not used}
}
\value{
Invisible \code{NULL}
}
\description{
Print the HTML code associated with the help documentation of one or more \R packages.
}
\examples{
\dontrun{
cat("---",
    "title: \"Help Documentation\"",
    "output:",
    "  html_document:",
    "    toc: true",
    "    toc_float: true",
    "---",
    sep = "\n", file = "test-help.Rmd")
PrintPackageHelp("inlmisc", file = "test-help.Rmd", toc = TRUE,
                 title_to_name = TRUE, notrun = FALSE)
rmarkdown::render("test-help.Rmd")
url <- file.path("file:/", getwd(), "test-help.html")
utils::browseURL(url)

file.remove("test-help.Rmd", "test-help.html")
}

}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
\keyword{documentation}
