% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AddNorthArrow.R
\name{AddNorthArrow}
\alias{AddNorthArrow}
\title{Add North Arrow to Plot}
\usage{
AddNorthArrow(crs = sp::CRS(), len = 0.05, lab = "N", rotate = 0,
  ...)
}
\arguments{
\item{crs}{'CRS', 'Raster*', or 'Spatial'.
Coordinate reference system (CRS), or any object with a CRS attribute
that can be extracted using the \code{\link[raster:projection]{crs}} function.
If missing (the default) the north arrow is point to the top of the plot
unless the \code{rotate} argument is specified.}

\item{len}{'numeric' number.
Arrow length expressed as a fraction of the plot height, by default is 5-percent.}

\item{lab}{'character' string.
North label, by default is \dQuote{N}.}

\item{rotate}{'numeric' number.
Arrow offset-rotation in degrees, where positive values are taken to be clockwise.}

\item{...}{Additional arguments to be passed to the \code{\link{GetInsetLocation}} function---used
to position the north arrow in the main plot region.}
}
\value{
Invisible \code{NULL}
}
\description{
Add a north arrow aligned to true north to a plot.
}
\examples{
m <- datasets::volcano
m <- m[nrow(m):1, ncol(m):1]
x <- seq(from = 2667405, length.out = ncol(m), by = 10)
y <- seq(from = 6478705, length.out = nrow(m), by = 10)
r <- raster::raster(m, xmn = min(x), xmx = max(x),
                    ymn = min(y), ymx = max(y),
                    crs = "+init=epsg:27200")
PlotMap(r, pal = GetColors(scheme = "DEM screen"))
AddNorthArrow(raster::crs(r), loc = "center")
AddNorthArrow(raster::crs(r), inset = 0.1)
AddNorthArrow(raster::crs(r), loc = "topleft", inset = 0.1)

}
\seealso{
\code{\link{PlotMap}}
}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
\keyword{hplot}
