% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{row_kron}
\alias{row_kron}
\title{Row-wise Kronecker products}
\usage{
row_kron(M1, M2, repl = NULL, n.repl = NULL, weights = NULL)
}
\arguments{
\item{M1}{A matrix that can be transformed into a sparse Matrix.}

\item{M2}{A matrix that can be transformed into a sparse Matrix.}

\item{repl}{An optional index vector.  For each entry, specifies which
replicate the row belongs to, in the sense used in
\code{INLA::inla.spde.make.A}}

\item{n.repl}{The maximum replicate index, in the sense used in
\code{INLA::inla.spde.make.A()}.}

\item{weights}{Optional scaling weights to be applied row-wise to the
resulting matrix.}
}
\value{
A \code{Matrix::sparseMatrix} object.
}
\description{
`r lifecycle::badge("deprecated") in favour of \code{\link[fmesher:fm_row_kron]{fmesher::fm_row_kron()}}.

Takes two Matrices and computes the row-wise Kronecker product.  Optionally
applies row-wise weights and/or applies an additional 0/1 row-wise Kronecker
matrix product.
}
\author{
Finn Lindgren \email{finn.lindgren@gmail.com}
}
\keyword{internal}
