% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{bru_fill_missing}
\alias{bru_fill_missing}
\title{Fill in missing values in Spatial grids}
\usage{
bru_fill_missing(
  data,
  where,
  values,
  layer = NULL,
  selector = NULL,
  batch_size = 500
)
}
\arguments{
\item{data}{A SpatialPointsDataFrame, SpatialPixelsDataFrame, or a
SpatialGridDataFrame containg data to use for filling}

\item{where}{A, matrix, data.frame, or SpatialPoints or
SpatialPointsDataFrame, containing the locations of the evaluated values}

\item{values}{A vector of values to be filled in where \code{is.na(values)} is
\code{TRUE}}

\item{layer, selector}{Specifies what data column or columns from which to
extract data, see \code{\link[=component]{component()}} for details.}

\item{batch_size}{Size of nearest-neighbour calculation blocks, to limit the
memory and computational complexity.}
}
\value{
An infilled vector of values
}
\description{
Computes nearest-available-value imputation for missing values in space
}
\examples{
\dontrun{
if (bru_safe_inla()) {
  points <-
    sp::SpatialPointsDataFrame(
      matrix(1:6, 3, 2),
      data = data.frame(val = c(NA, NA, NA))
    )
  input_coord <- expand.grid(x = 0:7, y = 0:7)
  input <-
    sp::SpatialPixelsDataFrame(
      input_coord,
      data = data.frame(val = as.vector(input_coord$y))
    )
  points$val <- bru_fill_missing(input, points, points$val)
  print(points)
}
}
}
