% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bru.inference.R
\name{bru_used_vars}
\alias{bru_used_vars}
\alias{bru_used_vars.character}
\alias{bru_used_vars.expression}
\alias{bru_used_vars.formula}
\title{Extract basic variable names from expression}
\usage{
bru_used_vars(x, functions = FALSE)

\method{bru_used_vars}{character}(x, functions = FALSE)

\method{bru_used_vars}{expression}(x, functions = FALSE)

\method{bru_used_vars}{formula}(x, functions = FALSE)
}
\arguments{
\item{x}{A \code{formula}, \code{expression}, or \code{character}}

\item{functions}{logical; if TRUE, include function names}
}
\value{
If successful, a character vector, otherwise \code{NULL}
}
\description{
Extracts the variable names from an R expression by pre- and post-processing
around \code{\link[=all.vars]{all.vars()}}.
First replaces \code{$} with \code{[[} indexing, so that internal column/variable names
are ignored, then calls \code{all.vars()}.
}
\section{Methods (by class)}{
\itemize{
\item \code{bru_used_vars(formula)}: Only the right-hand side is used.

}}
\examples{
bru_used_vars(~.)
bru_used_vars(~ a + b + c_latent + d_eval())
bru_used_vars(expression(a + b + c_latent + d_eval()))

bru_used_vars(~., functions = TRUE)
bru_used_vars(~ a + b + c_latent + d_eval(), functions = TRUE)
bru_used_vars(expression(a + b + c_latent + d_eval()), functions = TRUE)

bru_used_vars(a ~ b)
bru_used_vars(expression(a ~ b))

}
\seealso{
Other bru_used: 
\code{\link{bru_used}()},
\code{\link{bru_used_update}()}
}
\concept{bru_used}
\keyword{internal}
