\name{slbind}
\alias{slbind}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Combine Statlist Arrays}
\description{
Combines statslist arrays using a wrapper for \code{abind()} in the abind package.
}
\usage{
slbind(sformstats, statslist, type = 1, new.names=FALSE,...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{sformstats}{An sformstats object, possibly passed from \code{\link{sfl2sl}}}
  \item{statslist}{A statslist object, possibly passed from \code{\link{gen.intercepts}}}
  \item{type}{Indicates where the combining is going to occur in the output statslist. 1 for global, 2 for local.}
  \item{new.names}{Either logical or character string. Choose the ouput variable names. See details.}
  \item{...}{Additional arguments passed to \code{sf2nms()} if new.names=TRUE. See details}
}
\details{
The \code{new.names} parameter defaults to FALSE, which sets the variable names in the output to be whatever was passed from the names of the kth elements of each ijk array in \code{sformstats}, as in the default behavior in \code{abind()}. Setting \code{new.names} to TRUE tries to guess variable names using \code{\link{sf2nms}}. If TRUE, then \code{...} must contain an event.key from the eventlist object that \code{statslist} was built upon (e.g, \code{event.key=eventlist$event.key}). If \code{new.names} is passed as a character vector, then its length must be equal to the number of the kth elements of each ijk array in \code{sformstats}.

In the case that \code{new.names} is TRUE, it is possible to retrieve the original variable names by: \code{names(dimnames(output[[x]][[type]]))}, where output is the statslist generated by \code{slbind()}, x is any index, and type is \code{type} as defined above.
}
\author{Christopher Steven Marcum}
\note{\code{slbind} can accept \code{\link{abind}} arguments.
}
\seealso{\code{\link{sfl2sl}},\code{\link{gen.intercepts}},\code{\link{sf2nms}}}
\examples{
rawevents<-sample(rep(c("ran","eat","stay","eat","ran","play"),50))
actors<-rep(c("Jim","Bill","Pete"),100)
evmat<-cbind(rawevents,actors)
eventlist<-gen.evl(evmat)
beta.ints<-gen.intercepts(eventlist)
beta.sforms<-gen.sformlist(eventlist,c("a+b","bb"))
statslist<-slbind(beta.sforms,beta.ints)
statslist[[1]][[1]][1:3,,]

#Compare with:
statslist<-slbind(beta.sforms,beta.ints,new.names=TRUE,event.key=eventlist$event.key)
dimnames(statslist[[1]][[1]])
}
