% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{hubness.score}
\alias{hubness.score}
\title{Hubness score}
\usage{
hubness.score(
  graph,
  vertices = V(graph),
  directed = FALSE,
  mode = "all",
  loops = TRUE,
  scaled = TRUE
)
}
\arguments{
\item{graph}{A graph (network) of the igraph class.}

\item{vertices}{A vector of desired vertices, which could be obtained by the V function.}

\item{directed}{Logical scalar, whether to directed graph is analyzed. This argument
is ignored for undirected graphs.}

\item{mode}{The mode of Hubness score depending on the directedness of the graph.
If the graph is undirected, the mode "all" should be specified.
Otherwise, for the calculation of Hubness score based on
incoming connections select "in" and for the outgoing connections select "out".
Also, if all of the connections are desired, specify the "all" mode. Default mode is set to "all".}

\item{loops}{Logical; whether the loop edges are also counted.}

\item{scaled}{Logical; whether the end result should be 1-100 range normalized or not (default is TRUE).}
}
\value{
A numeric vector with the Hubness scores.
}
\description{
This function calculates the Hubness score of the desired nodes from a graph.
Hubness score reflects the power of each node in its surrounding environment and is
one of the major components of the IVI.
}
\examples{
\dontrun{
MyData <- coexpression.data
My_graph <- graph_from_data_frame(MyData)
GraphVertices <- V(My_graph)
Hubness.score <- hubness.score(graph = My_graph, vertices = GraphVertices,
                               directed = FALSE, mode = "all",
                               loops = TRUE, scaled = TRUE)
}
}
\seealso{
\code{\link[influential]{cent_network.vis}}

Other integrative ranking functions: 
\code{\link{comp_manipulate}()},
\code{\link{exir}()},
\code{\link{ivi.from.indices}()},
\code{\link{ivi}()},
\code{\link{spreading.score}()}
}
\concept{integrative ranking functions}
\keyword{hubness.score}
