% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate.R
\name{generate}
\alias{generate}
\title{Generate resamples, permutations, or simulations based on
`specify` and `hypothesize` inputs}
\usage{
generate(x, reps = 1, type = "bootstrap", ...)
}
\arguments{
\item{x}{a data frame that can be coerced into a \code{\link[dplyr]{tbl_df}}}

\item{reps}{the number of resamples to generate}

\item{type}{currently either \code{bootstrap}, \code{permute}, or \code{simulate}}

\item{...}{currently ignored}
}
\value{
A tibble containing \code{rep} generated datasets, indicated by the
\code{replicate} column.
}
\description{
Generate resamples, permutations, or simulations based on
`specify` and `hypothesize` inputs
}
\examples{
# Permutation test for two binary variables
  mtcars \%>\%
    dplyr::mutate(am = factor(am), vs = factor(vs)) \%>\%
    specify(am ~ vs, success = "1") \%>\%
    hypothesize(null = "independence") \%>\%
    generate(reps = 100, type = "permute")
}
