% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/v2_series_eng.R
\name{inegi_series}
\alias{inegi_series}
\alias{inegi_series}
\alias{inegi_series_json}
\title{Returns INEGI data series}
\usage{
inegi_series(series, token, metadata = FALSE, coerce = TRUE)

inegi_series_json(series, token, metadata = FALSE, coerce = TRUE)
}
\arguments{
\item{series}{Vector with complete url in character, obtained via INEGI}

\item{token}{API token supplied by INEGI}

\item{metadata}{Defaults to FALSE, if TRUE, returns a list with metadata information.}

\item{coerce}{Defaults to TRUE. The bi-weekly indicators will be coerced to monthly. All observations will be kept but in the same day of the month.}
}
\value{
data.frame or list
}
\description{
Returns a data.frame with the time series chosen from INEGI webservice. If the parameter Metadata is TRUE, a list
is returned with two objects: data and metadata.
}
\note{
if using JSON url, the "?callback?" at the end of the string is not needed.
}
\examples{
\dontrun{
# General INPC series
token<-"webservice_token"
url <- "http://www3.inegi.org.mx/sistemas/api/indicadores/v1//Indicador/216064/00000/es/false/xml/"
INPC <- inegi_series(url, token)
}
}
\author{
Eduardo Flores
}
