% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ragged_integer.R
\name{RaggedInteger}
\alias{RaggedInteger}
\title{RaggedInteger Class}
\description{
This is a ragged array which stores integers (numeric values).
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-RaggedInteger-new}{\code{RaggedInteger$new()}}
\item \href{#method-RaggedInteger-get_values}{\code{RaggedInteger$get_values()}}
\item \href{#method-RaggedInteger-get_length}{\code{RaggedInteger$get_length()}}
\item \href{#method-RaggedInteger-queue_update}{\code{RaggedInteger$queue_update()}}
\item \href{#method-RaggedInteger-queue_extend}{\code{RaggedInteger$queue_extend()}}
\item \href{#method-RaggedInteger-queue_shrink}{\code{RaggedInteger$queue_shrink()}}
\item \href{#method-RaggedInteger-size}{\code{RaggedInteger$size()}}
\item \href{#method-RaggedInteger-.update}{\code{RaggedInteger$.update()}}
\item \href{#method-RaggedInteger-.resize}{\code{RaggedInteger$.resize()}}
\item \href{#method-RaggedInteger-clone}{\code{RaggedInteger$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RaggedInteger-new"></a>}}
\if{latex}{\out{\hypertarget{method-RaggedInteger-new}{}}}
\subsection{Method \code{new()}}{
Create a new RaggedInteger
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RaggedInteger$new(initial_values)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{initial_values}}{a vector of the initial values for each individual}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RaggedInteger-get_values"></a>}}
\if{latex}{\out{\hypertarget{method-RaggedInteger-get_values}{}}}
\subsection{Method \code{get_values()}}{
Get the variable values.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RaggedInteger$get_values(index = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{index}}{optionally return a subset of the variable vector. If
\code{NULL}, return all values; if passed an [individual::Bitset]
or integer vector, return values of those individuals.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RaggedInteger-get_length"></a>}}
\if{latex}{\out{\hypertarget{method-RaggedInteger-get_length}{}}}
\subsection{Method \code{get_length()}}{
Get the lengths of the indiviudal elements in the ragged array
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RaggedInteger$get_length(index = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{index}}{optionally only get lengths for a subset of persons. If
\code{NULL}, return all lengths; if passed an [individual::Bitset]
or integer vector, return lengths of arrays for those individuals.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RaggedInteger-queue_update"></a>}}
\if{latex}{\out{\hypertarget{method-RaggedInteger-queue_update}{}}}
\subsection{Method \code{queue_update()}}{
Queue an update for a variable. There are 4 types of variable update:

\enumerate{
 \item{Subset update: }{The argument \code{index} represents a subset of the variable to
update. The argument \code{values} should be a vector whose length matches the size of \code{index},
which represents the new values for that subset.}
 \item{Subset fill: }{The argument \code{index} represents a subset of the variable to
update. The argument \code{values} should be a single number, which fills the specified subset.}
 \item{Variable reset: }{The index vector is set to \code{NULL} and the argument \code{values}
replaces all of the current values in the simulation. \code{values} should be a vector
whose length should match the size of the population, which fills all the variable values in
the population}
 \item{Variable fill: }{The index vector is set to \code{NULL} and the argument \code{values}
should be a single number, which fills all of the variable values in
the population.}
}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RaggedInteger$queue_update(values, index = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{values}}{a list of numeric vectors}

\item{\code{index}}{is the index at which to apply the change, use \code{NULL} for the
fill options. If using indices, this may be either a vector of integers or
an [individual::Bitset].}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RaggedInteger-queue_extend"></a>}}
\if{latex}{\out{\hypertarget{method-RaggedInteger-queue_extend}{}}}
\subsection{Method \code{queue_extend()}}{
extend the variable with new values
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RaggedInteger$queue_extend(values)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{values}}{to add to the variable}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RaggedInteger-queue_shrink"></a>}}
\if{latex}{\out{\hypertarget{method-RaggedInteger-queue_shrink}{}}}
\subsection{Method \code{queue_shrink()}}{
shrink the variable
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RaggedInteger$queue_shrink(index)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{index}}{a bitset or vector representing the individuals to remove}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RaggedInteger-size"></a>}}
\if{latex}{\out{\hypertarget{method-RaggedInteger-size}{}}}
\subsection{Method \code{size()}}{
get the size of the variable
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RaggedInteger$size()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RaggedInteger-.update"></a>}}
\if{latex}{\out{\hypertarget{method-RaggedInteger-.update}{}}}
\subsection{Method \code{.update()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RaggedInteger$.update()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RaggedInteger-.resize"></a>}}
\if{latex}{\out{\hypertarget{method-RaggedInteger-.resize}{}}}
\subsection{Method \code{.resize()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RaggedInteger$.resize()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RaggedInteger-clone"></a>}}
\if{latex}{\out{\hypertarget{method-RaggedInteger-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RaggedInteger$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
