% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/targeted_event.R
\name{TargetedEvent}
\alias{TargetedEvent}
\title{TargetedEvent Class}
\description{
Describes a targeted event in the simulation.
This is useful for events which are triggered for a sub-population.
}
\section{Super class}{
\code{\link[individual:Event]{individual::Event}} -> \code{TargetedEvent}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{TargetedEvent$new()}}
\item \href{#method-schedule}{\code{TargetedEvent$schedule()}}
\item \href{#method-get_scheduled}{\code{TargetedEvent$get_scheduled()}}
\item \href{#method-clear_schedule}{\code{TargetedEvent$clear_schedule()}}
\item \href{#method-.process_listener}{\code{TargetedEvent$.process_listener()}}
\item \href{#method-.process_listener_cpp}{\code{TargetedEvent$.process_listener_cpp()}}
\item \href{#method-clone}{\code{TargetedEvent$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="individual" data-topic="Event" data-id=".process">}\href{../../individual/html/Event.html#method-.process}{\code{individual::Event$.process()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="individual" data-topic="Event" data-id=".tick">}\href{../../individual/html/Event.html#method-.tick}{\code{individual::Event$.tick()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="individual" data-topic="Event" data-id="add_listener">}\href{../../individual/html/Event.html#method-add_listener}{\code{individual::Event$add_listener()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Initialise a TargetedEvent.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TargetedEvent$new(population_size)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{population_size}}{the size of the population.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-schedule"></a>}}
\if{latex}{\out{\hypertarget{method-schedule}{}}}
\subsection{Method \code{schedule()}}{
Schedule this event to occur in the future.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TargetedEvent$schedule(target, delay)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{target}}{the individuals to pass to the listener, this may be 
either a vector of integers or a \code{\link[individual]{Bitset}}.}

\item{\code{delay}}{the number of time steps to wait before triggering the event,
can be a scalar in which case all targeted individuals are scheduled for
for the same delay or a vector of values giving the delay for that
individual.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_scheduled"></a>}}
\if{latex}{\out{\hypertarget{method-get_scheduled}{}}}
\subsection{Method \code{get_scheduled()}}{
Get the individuals who are scheduled as a \code{\link[individual]{Bitset}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TargetedEvent$get_scheduled()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clear_schedule"></a>}}
\if{latex}{\out{\hypertarget{method-clear_schedule}{}}}
\subsection{Method \code{clear_schedule()}}{
Stop a future event from triggering for a subset of individuals.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TargetedEvent$clear_schedule(target)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{target}}{the individuals to clear, this may be either a vector of integers or
a \code{\link[individual]{Bitset}}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-.process_listener"></a>}}
\if{latex}{\out{\hypertarget{method-.process_listener}{}}}
\subsection{Method \code{.process_listener()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TargetedEvent$.process_listener(listener)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-.process_listener_cpp"></a>}}
\if{latex}{\out{\hypertarget{method-.process_listener_cpp}{}}}
\subsection{Method \code{.process_listener_cpp()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TargetedEvent$.process_listener_cpp(listener)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TargetedEvent$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
