% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{simulation_loop}
\alias{simulation_loop}
\title{A premade simulation loop}
\usage{
simulation_loop(
  variables = list(),
  events = list(),
  processes = list(),
  timesteps
)
}
\arguments{
\item{variables}{a list of Variables}

\item{events}{a list of Events}

\item{processes}{a list of processes to execute on each timestep}

\item{timesteps}{the number of timesteps to simulate}
}
\description{
Run a simulation where event listeners take precedence 
over processes for state changes.
}
\examples{
population <- 4
timesteps <- 5
state <- CategoricalVariable$new(c('S', 'I', 'R'), rep('S', population))
renderer <- Render$new(timesteps)

transition <- function(from, to, rate) {
  return(function(t) {
    from_state <- state$get_index_of(from)
    state$queue_update(
      to,
      from_state$sample(rate)
    )
  })
}

processes <- list(
  transition('S', 'I', .2),
  transition('I', 'R', .1),
  transition('R', 'S', .05),
  categorical_count_renderer_process(renderer, state, c('S', 'I', 'R'))
)

simulation_loop(variables=list(state), processes=processes, timesteps=timesteps)
renderer$to_dataframe()
}
