#' Survival of mice with glioma under different treatments.
#'
#' A dataset from an animal experiment described in Stankovic (2018), shown in Figure 6J and 6K.
#'
#' @details
#' The data were read directly from the survival plots in the publication with the help of Plot Digitizer, version 2.6.9.
#'
#' @format
#' \describe{
#'   \item{Figure}{The figure in the publication where the data is shown}
#'   \item{Time}{Survival in days}
#'   \item{Status}{Right-censor status: 1 means observed event}
#'   \item{Group}{Experimental group identifier}
#'   \item{Colour}{Colour used in the Stankovic publication to mark this group}
#' }
#' @source Dudvarski Stankovic N, Bicker F, Keller S, et al. EGFL7 enhances surface expression of integrin a5b1 to promote angiogenesis in malignant brain tumors. EMBO Mol Med. 2018;10(9):e8420. doi:10.15252/emmm.201708420 \url{https://www.ncbi.nlm.nih.gov/pmc/articles/PMC6127886/}
"stankovic"
