% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/barplotExp.R
\name{barplotExp}
\alias{barplotExp}
\title{barplotExp}
\usage{
barplotExp(x, palette, main, selectOrder, effecLibSize)
}
\arguments{
\item{x}{A DGEList object from "edgeR".}

\item{palette}{Character. Name of a discrete color palette from the "paletteer" package.}

\item{main}{Character. Title for the barplot.}

\item{selectOrder}{Character. Either "Groups" (order samples by group) or "Samples" (order by sample name).}

\item{effecLibSize}{Logical. If TRUE, use effective library size (norm factors × raw size); otherwise use raw size.}
}
\value{
A "ggplot" object showing per-sample barplots of library size in millions.
}
\description{
Create a barplot of library sizes per sample, optionally using effective library sizes.
}
\details{
This function extracts library size information from an "edgeR" "DGEList", computes
effective library sizes if requested, orders samples by group or name, and plots
library sizes (in millions) colored by group.
\enumerate{
\item Extracts or computes (effecLibSize = TRUE) the library size for each sample.
\item Orders samples by group or sample name per selectOrder.
\item Plots bar heights as library size (×10^6) with white fill and colored borders.
}
}
