% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binaryOperators.R
\name{\%m+\%}
\alias{\%m+\%}
\alias{BinaryOperators}
\alias{\%m-\%}
\alias{\%m*\%}
\alias{\%m/\%}
\title{Binary Operators with Implicit Expansion}
\usage{
x \%m+\% y

x \%m-\% y

x \%m*\% y

x \%m/\% y
}
\arguments{
\item{x, y}{Arrays or objects that can be coerced to arrays using \code{\link[=as.array]{as.array()}}.}
}
\value{
The result of \code{mmapply('XXX', x, y)},
with \code{XXX} replaced by the corresponding element-wise binary operator.
}
\description{
Modified versions of binary operators that support implicit expansion.
Arguments are passed to \code{\link[=mmapply]{mmapply()}} with the corresponding element-wise binary operator.
For instance, \code{x \%m+\% y} is equivalent to \code{mmapply('+', x, y)}.
}
\examples{
x <- c(1,2,3)
y <- t(c(4,5))
x \%m+\% y

m <- matrix(3*(1:12)^2, 3, 4)
cm <- t(colMeans(m))
m \%m-\% cm

}
\seealso{
\code{\link{mmapply}}
}
