% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/globals.R
\docType{data}
\name{IMD_GLOBALS}
\alias{IMD_GLOBALS}
\title{Internal Immundata Global Configuration}
\format{
An object of class \code{list} of length 3.
}
\usage{
IMD_GLOBALS
}
\description{
\code{IMD_GLOBALS} is an internal list that stores globally used constants across the Immundata system.
It is not intended for direct use by package users, but rather to ensure consistency in schema
field names, default file names, and internal error messages.
}
\section{Components}{

\itemize{
\item \code{messages}: Named list of default messages and error texts (e.g., \code{"NotImpl"}).
\item \code{schema}: Standardized column names for internal schema usage. These include:
\itemize{
\item \code{barcode}: Column name for cell barcode IDs.
\item \code{receptor}: Column name for receptor unique identifiers.
\item \code{repertoire}: Column name for repertoire group IDs.
\item \code{metadata_filename}: Column name for metadata files (internal).
\item \code{count}: Column name for receptor count per group.
\item \code{filename}: Original column name used in user metadata.
}
\item \code{files}: Default file names used to store structured Immundata:
\itemize{
\item \code{receptors}: File name for receptor-level data (\code{receptors.parquet}).
\item \code{annotations}: File name for annotation-level data (\code{annotations.parquet}).
}
}
}

\keyword{internal}
