% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fuzzy_thresholding.R
\name{ThresholdFuzzy}
\alias{ThresholdFuzzy}
\title{Fuzzy Entropy Image Segmentation}
\usage{
ThresholdFuzzy(im, n = 50, maxiter = 100, omegamax = 0.9,
  omegamin = 0.1, c1 = 2, c2 = 2, mutrate = 0.2, vmaxcoef = 0.1,
  intervalnumber = 1000, returnvalue = FALSE)
}
\arguments{
\item{im}{a grayscale image of class cimg}

\item{n}{swarm size}

\item{maxiter}{maximum iterative time}

\item{omegamax}{maximum inertia weight}

\item{omegamin}{minimum inertia weight}

\item{c1}{acceleration coefficient}

\item{c2}{acceleration coefficient}

\item{mutrate}{rate of gaussian mutation}

\item{vmaxcoef}{coefficient of maximum velocity}

\item{intervalnumber}{interval number of histogram}

\item{returnvalue}{if returnvalue is TRUE, returns a threshold value. if FALSE, returns a pixel set.}
}
\value{
a pixsel set or a numeric
}
\description{
automatic fuzzy thresholding based on particle swarm optimization
}
\examples{
g <- grayscale(boats)
layout(matrix(1:2, 1, 2))
plot(g, main = "Original")
ThresholdFuzzy(g) \%>\% plot(main = "Fuzzy Thresholding")
}
\references{
Linyi Li, Deren Li (2008). Fuzzy entropy image segmentation based on particle swarm optimization. Progress in Natural Science.
}
\author{
Shota Ochi
}
