% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{read_tif}
\alias{read_tif}
\alias{tif_read}
\title{Read an image stored in the TIFF format}
\usage{
read_tif(path, frames = "all", list_safety = "error", msg = TRUE)

tif_read(path, frames = "all", list_safety = "error", msg = TRUE)
}
\arguments{
\item{path}{A string. The path to the tiff file to read.}

\item{frames}{Which frames do you want to read. Default all. To read the 2nd
and 7th frames, use \code{frames = c(2, 7)}.}

\item{list_safety}{A string. This is for type safety of this function. Since
returning a list is unlikely and probably unexpected, the default is to
error. You can instead opt to throw a warning (\code{list_safety = "warning"})
or to just return the list quietly (\code{list_safety = "none"}).}

\item{msg}{Print an informative message about the image being read?}
}
\value{
An object of class \link{ijtiff_img} or a list of \link{ijtiff_img}s.
}
\description{
Reads an image from a TIFF file/content into a numeric array or list.
}
\details{
TIFF files have the capability to store multiple images, each having multiple
channels. Typically, these multiple images represent the sequential frames in
a time-stack or z-stack of images and hence each of these images has the same
dimension. If this is the case, they are all read into a single 4-dimensional
array \code{img} where \code{img} is indexed as \code{img[y, x, channel, frame]} (where we
have \verb{y, x} to comply with the conventional \verb{row, col} indexing of a matrix -
it means that images displayed as arrays of numbers in the R console will
have the correct orientation). However, it is possible that the images in the
TIFF file have varying dimensions (most people have never seen this), in
which case they are read in as a list of images, where again each element of
the list is a 4-dimensional array \code{img}, indexed as \code{img[y, x, channel, frame]}.

A (somewhat random) set of TIFF tags are attributed to the read image. These
are IMAGEDEPTH, BITSPERSAMPLE, SAMPLESPERPIXEL, SAMPLEFORMAT, PLANARCONFIG,
COMPRESSION, THRESHHOLDING, XRESOLUTION, YRESOLUTION, RESOLUTIONUNIT, INDEXED
and ORIENTATION. More tags should be added in a subsequent version of this
package. You can read about TIFF tags at
https://www.awaresystems.be/imaging/tiff/tifftags.html.

TIFF images can have a wide range of internal representations, but only the
most common in image processing are supported (8-bit, 16-bit and 32-bit
integer and 32-bit float samples).
}
\note{
\itemize{ \item 12-bit TIFFs are not supported. \item There is no
standard for packing order for TIFFs beyond 8-bit so we assume big-endian
packing}.
}
\examples{
img <- read_tif(system.file("img", "Rlogo.tif", package = "ijtiff"))
}
\seealso{
\code{\link[=write_tif]{write_tif()}}
}
\author{
Simon Urbanek wrote most of this code for the 'tiff' package. Rory
Nolan lifted it from there and changed it around a bit for this 'ijtiff'
package. Credit should be directed towards Lord Urbanek.
}
